function V = HW4InsertNeedleVF(Fins,pnc,Fh,Fhn,r,Kpos,Korient )
%Virtual fixture for aligning a needle while holding tip at insertion point
%This is equivalent to rotating needle about its z-axis, assuming that it 
%is already positioned correctly
%
% Fins  = local coord system at insertion point
% pnc   = position of needle center with respect to Fins
% Fh    = Current hand coordinates
% Fhn   = grasp Fn = Fh*Fhn, where Fh = hand coordinate system
% r     = radius of needle
% Kpos  = stiffness for holding needle position
% Korient = stiffness for aligning the needle
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

Fnc = Frame(Fins.R,Fins*pnc);   % hand must rotate and align about here
Fc  = Fh.Inverse()*Fnc;         % Transform into hand coordinates         
z3  = [0,0,0];
V   = HW4VirtualFixture(Fc,-[0,KKpos,Kpos],-[0,Kpos,Kpos],z3,z3,z3,z3,
                        Fc.R,-[Korient,Korient,0],-[Korient,Korient,0],z3,z3);
end